unit colourlistbox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TColourListBox = class(TListBox)
  protected
     function GetItemColour(ndx: Integer): LongInt;
     procedure SetItemColour(ndx: Integer; val: LongInt);
  public
     constructor Create(AOwner: TComponent); override;
     property ItemColour[ndx: Integer]: LongInt read GetItemColour write SetItemColour;
  published
     procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TColourListBox]);
end;

constructor TColourListBox.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     Style:=lbOwnerDrawVariable;
end;

function TColourListBox.GetItemColour(ndx:Integer):longint;
begin
     GetItemColour:=SendMessage(handle, LB_GETITEMDATA, ndx, 0);
end;

procedure TColourListBox.SetItemColour(ndx:Integer; val:longint);
begin
     SendMessage(handle, LB_SETITEMDATA, ndx, val);
end;

procedure TColourListBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
     Canvas.Font.Color:=ItemColour[Index];
     Canvas.FillRect(Rect);
     Canvas.MoveTo(Rect.Left+2, Rect.Top);
     SetTextAlign(Canvas.Handle, TA_LEFT OR TA_UPDATECP);
     if Index < Items.Count then
        Canvas.TextOut(Rect.Left + 2, Rect.Top, Items[Index]);
end;

end.
